/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeRec {
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int HOUR = 2;
    private static final int YEAR = 3;
    private static final int DAY = 4;
    private static final int MONTH = 5;
    private static final int WEEKDAY = 7;
    private static final int LENGTH = 8;
    private byte[] data = null;

    public TimeRec() {
        this(new Date());
    }

    public TimeRec(Date date) {
        this.setDate(date);
    }

    public TimeRec(byte[] bytes, int offset) {
        if (bytes == null || bytes.length - offset < 8) {
            throw new IllegalArgumentException("TimeRec requires a 8 byte array.");
        }
        this.data = new byte[8];
        System.arraycopy(bytes, offset, this.data, 0, 8);
    }

    public TimeRec(InputStream inputStream) throws IOException {
        this.data = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.data[i] = (byte)inputStream.read();
        }
    }

    public void setDate(Date date) {
        this.data = new byte[8];
        if (date != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            this.data[0] = (byte)gc.get(13);
            this.data[1] = (byte)gc.get(12);
            this.data[2] = (byte)gc.get(11);
            this.data[3] = (byte)(gc.get(1) - 1900);
            this.data[4] = (byte)(gc.get(5) - 1);
            this.data[5] = (byte)gc.get(2);
            this.data[7] = (byte)gc.get(7);
        }
    }

    public Date getDate() {
        int year = this.data[3] + 1900;
        if (year < 1940) {
            year += 100;
        }
        GregorianCalendar gc = new GregorianCalendar(year, this.data[5] + 1, this.data[4], this.data[2], this.data[1], this.data[0]);
        return gc.getTime();
    }

    public byte[] getBytes() {
        return this.data;
    }
}

